<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class InvitoAzione {
        private $db;
        private $id;
        private $nome;
        private $spazioOccupato;
        private $percorsoImmagine;
        private $altezza;
        private $testo;
        private $linkPulsante;
        private $stilePulsante;
        private $titoloPulsante;
        private $numeroClick;
        private $dataCreazione;
        private $dataUltimoClick;
        
        public function __construct($db, $id, $nome="", $spazioOccupato="", $percorsoImmagine="", $altezza="", $testo="", $linkPulsante="", $stilePulsante="", $titoloPulsante="", $numeroClick=0, $dataCreazione="", $dataUltimoClick="") {
            $this->db = $db;
            $this->id = $id;
            $this->nome = $nome;
            $this->spazioOccupato = $spazioOccupato;
            $this->percorsoImmagine = $percorsoImmagine;
            $this->altezza = $altezza;
            $this->testo = $testo;
            $this->linkPulsante = $linkPulsante;
            $this->stilePulsante = $stilePulsante;
            $this->titoloPulsante = $titoloPulsante;
            $this->numeroClick = $numeroClick;
            $this->dataCreazione = $dataCreazione;
            $this->dataUltimoClick = $dataUltimoClick;
        }

        function crea() {
            $dataOggi = date("Y-m-d H:m:s");
            $query ="INSERT INTO geec_invitiAzione VALUES(NULL,'$this->nome','$this->spazioOccupato','$this->percorsoImmagine','$this->altezza','$this->testo','$this->linkPulsante','$this->stilePulsante','$this->titoloPulsante',0,'$dataOggi','$dataOggi')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query    = "UPDATE geec_invitiAzione SET nome='$this->nome', spazioOccupato='$this->spazioOccupato', percorsoImmagine='$this->percorsoImmagine', altezza='$this->altezza', testo='$this->testo', linkPulsante='$this->linkPulsante', stilePulsante='$this->stilePulsante', titoloPulsante='$this->titoloPulsante' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function cambiaImmagineElemento($percorsoImmagine) {
            $query    = "UPDATE geec_invitiAzione SET percorsoImmagine='$percorsoImmagine' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_invitiAzione",$this->id);
            
            // elimina le occorrenze in cui la form è presente, l'id di questo componente è 20
            eliminaOccorrenzeComponente($this->db,$this->id,20);
        }
        
        function duplica($prefisso = "Copia di ") {
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geec_invitiAzione WHERE id={$this->id}");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geec_invitiAzione SELECT * FROM tabella_temporanea;");
            $idContenutoDuplicato = $this->db->idUltimoElemento();
            
            $this->db->eseguiQueryScrittura("UPDATE geec_invitiAzione SET nome = CONCAT('$prefisso', ' ', nome), numeroClick=0 WHERE id=$idContenutoDuplicato");
            return $idContenutoDuplicato;
        }
        
        function caricaDatiDalDatabase() {
            $datiInvitoAzione   = $this->db->leggiSingolaRiga("geec_invitiAzione",$this->id);
            $this->nome = $datiInvitoAzione["nome"];
            $this->spazioOccupato   = $datiInvitoAzione["spazioOccupato"];
            $this->percorsoImmagine = $datiInvitoAzione["percorsoImmagine"];
            $this->altezza          = $datiInvitoAzione["altezza"];
            $this->testo            = $datiInvitoAzione["testo"];
            $this->linkPulsante     = $datiInvitoAzione["linkPulsante"];
            $this->stilePulsante    = $datiInvitoAzione["stilePulsante"];
            $this->titoloPulsante   = $datiInvitoAzione["titoloPulsante"];
            $this->numeroClick      = $datiInvitoAzione["numeroClick"];
            $this->dataCreazione    = $datiInvitoAzione["dataCreazione"];
            $this->dataUltimoClick  = $datiInvitoAzione["dataUltimoClick"];
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getSpazioOccupato() {
            return $this->spazioOccupato;
        }

        public function getPercorsoImmagine() {
            return $this->percorsoImmagine;
        }

        public function getAltezza() {
            return $this->altezza;
        }

        public function getTesto() {
            return $this->testo;
        }

        public function getLinkPulsante() {
            return $this->linkPulsante;
        }

        public function getStilePulsante() {
            return $this->stilePulsante;
        }

        public function getTitoloPulsante() {
            return $this->titoloPulsante;
        }

        public function getNumeroClick() {
            return $this->numeroClick;
        }

        public function getDataCreazione() {
            return $this->dataCreazione;
        }

        public function getDataUltimoClick() {
            return $this->dataUltimoClick;
        }

        public function setDb($db) {
            $this->db = $db;
        }

        public function setId($id) {
            $this->id = $id;
        }

        public function setNome($nome) {
            $this->nome = $nome;
        }

        public function setSpazioOccupato($spazioOccupato) {
            $this->spazioOccupato = $spazioOccupato;
        }

        public function setPercorsoImmagine($percorsoImmagine) {
            $this->percorsoImmagine = $percorsoImmagine;
        }

        public function setAltezza($altezza) {
            $this->altezza = $altezza;
        }

        public function setTesto($testo) {
            $this->testo = $testo;
        }

        public function setLinkPulsante($linkPulsante) {
            $this->linkPulsante = $linkPulsante;
        }

        public function setStilePulsante($stilePulsante) {
            $this->stilePulsante = $stilePulsante;
        }

        public function setTitoloPulsante($titoloPulsante) {
            $this->titoloPulsante = $titoloPulsante;
        }

        public function setNumeroClick($numeroClick) {
            $this->numeroClick = $numeroClick;
        }

        public function setDataCreazione($dataCreazione) {
            $this->dataCreazione = $dataCreazione;
        }

        public function setDataUltimoClick($dataUltimoClick) {
            $this->dataUltimoClick = $dataUltimoClick;
        }
        
    }